//+------------------------------------------------------------------+
//|                                     Simple Example RSI Level.mq5 |
//|                        Copyright 2020, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2020, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.000"
//--- input parameters
input group             "RSI"
input int                  Inp_RSI_ma_period    = 5;           // RSI: averaging period
input ENUM_APPLIED_PRICE   Inp_RSI_applied_price= PRICE_CLOSE; // RSI: type of price
input double               Inp_RSI_LevelUP      = 75;          // RSI: Level UP
input double               Inp_RSI_LevelDOWN    = 25;          // RSI: Level DOWN
//---
int      handle_iCustom;      // variable for storing the handle of the iCustom indicator
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   Print(__FUNCTION__,", IN ...");
   int windows_total=(int)ChartGetInteger(0,CHART_WINDOWS_TOTAL,0);
   for(int i=windows_total-1; i>=0; i--)
     {
      int indicators_total=ChartIndicatorsTotal(0,i);
      for(int j=indicators_total-1; j>=0; j--)
        {
         string indicator_name=ChartIndicatorName(0,i,j);
         Print("  Subwindow ",i,", Indicator ",indicator_name);
        }
     }
//--- create handle of the indicator iCustom
   handle_iCustom=iCustom(Symbol(),Period(),"RSI Levels");
//--- if the handle is not created
   if(handle_iCustom==INVALID_HANDLE)
     {
      //--- tell about the failure and output the error code
      PrintFormat("Failed to create handle of the iCustom indicator for the symbol %s/%s, error code %d",
                  Symbol(),
                  EnumToString(Period()),
                  GetLastError());
      //--- the indicator is stopped early
      return(INIT_FAILED);
     }
//---
   windows_total=(int)ChartGetInteger(0,CHART_WINDOWS_TOTAL,0);
   ChartIndicatorAdd(0,windows_total,handle_iCustom);
   Print(__FUNCTION__,", OUT...");
   windows_total=(int)ChartGetInteger(0,CHART_WINDOWS_TOTAL,0);
   for(int i=windows_total-1; i>=0; i--)
     {
      int indicators_total=ChartIndicatorsTotal(0,i);
      for(int j=indicators_total-1; j>=0; j--)
        {
         string indicator_name=ChartIndicatorName(0,i,j);
         Print("  Subwindow ",i,", Indicator ",indicator_name);
        }
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Comment("");
//---
   Print(__FUNCTION__);
   int windows_total=(int)ChartGetInteger(0,CHART_WINDOWS_TOTAL,0);
   for(int i=windows_total-1; i>=0; i--)
     {
      int indicators_total=ChartIndicatorsTotal(0,i);
      for(int j=indicators_total-1; j>=0; j--)
        {
         string indicator_name=ChartIndicatorName(0,i,j);
         Print("  Subwindow ",i,", Indicator ",indicator_name);
         if(indicator_name=="RSI("+IntegerToString(Inp_RSI_ma_period)+")" || indicator_name=="RSI Levels")
           {
            ChartIndicatorDelete(0,i,indicator_name);
            IndicatorRelease(handle_iCustom);
           }
        }
     }
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   string text_rsi="";
   double rsi[];
   ArraySetAsSeries(rsi,true);
   int start_pos=0,count=3;
   if(!iGetArray(handle_iCustom,0,start_pos,count,rsi))
      return;
   for(int i=count-1; i>=0; i--)
      text_rsi = text_rsi+"RSI"+"["+IntegerToString(i)+"]"+" "+DoubleToString(rsi[i],2)+" | ";
   Comment(text_rsi);
  }
//+------------------------------------------------------------------+
//| Get value of buffers                                             |
//+------------------------------------------------------------------+
bool iGetArray(const int handle,const int buffer,const int start_pos,
               const int count,double &arr_buffer[])
  {
   bool result=true;
   if(!ArrayIsDynamic(arr_buffer))
     {
      PrintFormat("ERROR! EA: %s, FUNCTION: %s, this a no dynamic array!",__FILE__,__FUNCTION__);
      return(false);
     }
   ArrayFree(arr_buffer);
//--- reset error code
   ResetLastError();
//--- fill a part of the iBands array with values from the indicator buffer
   int copied=CopyBuffer(handle,buffer,start_pos,count,arr_buffer);
   if(copied!=count)
     {
      //--- if the copying fails, tell the error code
      PrintFormat("ERROR! EA: %s, FUNCTION: %s, amount to copy: %d, copied: %d, error code %d",
                  __FILE__,__FUNCTION__,count,copied,GetLastError());
      //--- quit with zero result - it means that the indicator is considered as not calculated
      return(false);
     }
   return(result);
  }
//+------------------------------------------------------------------+
